  '*****************************************************************************
  '  Program   : Countdown Timer.Bas
  '  Author    : Mike
  '  Date      : 5/03/2016     Version 0.0.0.0
  '  Requires MMBasic 5.1 or later and an ILI9341 based LCD panel with touch
  '  Notes     : Set up to Hrs:Mins:Secs
  '  14 March  : Implement the Countdown
  ' Note: If programmed into a new chip, then the LCD has to be configured.
  ' Open MM Chat above. In the box type the following 3 commands.
  ' OPTION LCDPANEL ILI9341, L, 2, 23, 6 (ENTER)
  ' OPTION TOUCH 7, 15 (ENTER)
  ' GUI CALIBRATE (ENTER). Follow instructions on the screen to calibrate. Done.
  ' Run GUI TEST LCDPANEL.
  ' Configure unused pins as Outputs & drive to a logic-low state.
  ' Pins 9,10,16,18,21,22,24,26
  '*****************************************************************************
  Option Autorun On
  Option Explicit 'Every variable must be explicitly declared using the
  'DIM statement.
  Option Default None 'Every variable must have their type explictly defined.
  
  Dim Integer KeyCoord(4, 5)
  Dim String KeyCaption(4)
  Dim Float Hrs, Mins, Secs
  Dim Float Nmbr
  'These pins are not used, so put them LOW.
  SetPin 9, DOUT
  PIN(9) = 0          'Put Pin 9 Low.
  SetPin 10, DOUT
  PIN(10) = 0         'Put Pin 10 Low.  
  SetPin 17, DOUT
  PIN(17) = 0         'Put Pin 17 Low.
  SetPin 18, DOUT
  PIN(18) = 0         'Put Pin 18 Low.
  SetPin 21, DOUT
  PIN(21) = 0         'Put Pin 21 Low.
  SetPin 22, DOUT
  PIN(22) = 0         'Put Pin 22 Low.
  SetPin 24, DOUT
  PIN(24) = 0         'Put Pin 24 Low.
  SetPin 26, DOUT
  PIN(26) = 0         'Put Pin 26 Low.

  'Restore the settings.  If this is the first time set the defaults
  Var Restore
  'Set up the Relay Port
  SetPin 16, DOUT     'Allocate Pin 1 as (D)igital (OUT)put with (O)pen (C)ollector
  PIN(16) = 0         'Put Pin 16 Low. Turn the relay OFF.
  
  '*****************************************************************************
Start:
  Hrs = 0   'Hours
  Mins = 1  'Minutes
  Secs = 30	'Seconds
  Cls
  ChangeTime
  '*****************************************************************************
  'This is the 'Start' of the program.
  '*****************************************************************************
  Cls
  PIN(16) = 1       'Put Pin 16 High. Turn the relay ON.
  Display:          'Display the Countdown.
  Text MM.HRes/2,MM.VRes/2,Str$(Hrs,2,0,"0")+":"+Str$(Mins,2,0,"0")+":"+Str$(Secs,2,0,"0"), CT, 2, 2, RGB(Cyan), RGB(Blue)
  ' *****************
CountDownSecs:
  If Secs = 0 Then
    GoTo CountDownMins
  EndIf
  Secs = Secs - 1
  Pause 1000        'Change this for the countdown timer
  GoTo Display
  ' *****************
CountDownMins:
  If Mins = 0 And Secs = 0 Then
    GoTo CountDownHrs
  EndIf
  Mins = Mins - 1
  Secs = Secs + 60
  GoTo CountDownSecs
  ' *****************
CountDownHrs:
  If Hrs = 0 And Mins = 0 And Secs = 0 Then
    GoTo Finish
  EndIf
  Hrs = Hrs - 1
  Mins = Mins + 60
  GoTo CountDownMins
  ' *****************
Finish:
  PIN(16) = 0        'Put Pin 16 Low. Turn the relay OFF.
  ' *****************
  ' Draw the FINISHED button at the bottom of the screen
  Line 0, 200, MM.HRes, 200, 1, RGB(Yellow)
  KeyCoord(3,0) = MM.HRes/4
  KeyCoord(3,1) = 205
  KeyCoord(3,2) = MM.HRes/2
  KeyCoord(3,3) = 34
  KeyCoord(3,4) = RGB(Cyan)
  KeyCaption(3) = "Finished"
  'Go to Sub DrawButton, then come back and finish rest of line.
  DrawButton 3, 0
  ' *****************
  Pause 2000        'Hold the current display for 2 seconds.
  GoTo Start
  
  '*****************************************************************************
Sub ChangeTime
  Do
    Cls
    'Go to Sub DrawOption, then come back and finish rest of line.
    DrawOption 0, RGB(White), "Change current time", 0, Hrs, "Hrs"
    'Go to Sub DrawOption, then come back and finish rest of line.
    DrawOption 1, RGB(Yellow), "Minutes", 70, Mins, "Min"
    'Go to Sub DrawOption, then come back and finish rest of line.
    DrawOption 2, RGB(Green), "Seconds", 137, Secs, "Sec"
    ' *****************
    ' Draw the Start Countdown button at the bottom of the screen
    Line 0, 200, MM.HRes, 200, 1, RGB(Yellow)
    KeyCoord(3,0) = MM.HRes/4
    KeyCoord(3,1) = 205
    KeyCoord(3,2) = MM.HRes/2
    KeyCoord(3,3) = 34
    KeyCoord(3,4) = RGB(Cyan)
    KeyCaption(3) = "Start Countdown"
    'Go to Sub DrawButton, then come back and finish rest of line.
    DrawButton 3, 0
    ' *****************
    ' Get the selected button and take action based on the button
    Select Case CheckButtonPress(0, 3)
        ' *****************
      Case 0
        Nmbr = Hrs
        'Go to Sub GetFloat, then come back and finish rest of line.
        GetFloat "Hours", Nmbr
        If Nmbr >12 Then
          'Go to Sub MessageBox, then come back and finish rest of line.
          MessageBox "Invalid number", "More than 12 hours"
        Else
          Hrs = Nmbr
        EndIf
        ' *****************
      Case 1
        Nmbr = Mins
        'Go to Sub GetFloat, then come back and finish rest of line.
        GetFloat "Miinutes", Nmbr
        If Nmbr >59 Then
          'Go to Sub MessageBox, then come back and finish rest of line.
          MessageBox "Invalid number", "More than 59 minutes"
        Else
          Mins = Nmbr
        EndIf
        ' *****************
      Case 2
        Nmbr = Secs
        'Go to Sub GetFloat, then come back and finish rest of line.
        GetFloat "Seconds", Nmbr
        If Nmbr >59 Then
          'Go to Sub MessageBox, then come back and finish rest of line.
          MessageBox "Invalid number", "More than 59 seconds"
        Else
          Secs = Nmbr
        EndIf
        ' *****************
      Case 3
        'Save variables to EEPROM.
        Var Save Hrs, Mins, Secs
        Exit Sub
    End Select
  Loop
End Sub '(ChangeTime)
  '*****************************************************************************
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Draw options and get button presses.
  ' These two subs draw the option title, value and a button labeled "CHANGE"
  ' The function CheckButtonPress() will check if a button has been touched.
  ' These routines use the arrays KeyCoord() and KeyCaption() to track the
  ' coordinates and size of each button and save its caption.
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Draw a single option
  'Go to Sub DrawOption, then come back and finish rest of line.
Sub DrawOption Nmbr As Integer, Colour As Integer, Caption As String, Vert As Integer, var As Float, Units As String
  Const Btn_Width = 120
  Const FontH = MM.FontHeight * 2
  Const space = 4
  Text MM.HRes/2, Vert, Caption, CT, 2, 1, colour
  If var <> -1 Then Text MM.HRes/2 - 20, Vert + FontH + space, Str$(var) + " " + Units, RT, 2, 1, colour
  KeyCoord(Nmbr,0) = MM.HRes/2 + 20
  KeyCoord(Nmbr,1) = Vert + FontH + space/2
  KeyCoord(Nmbr,2) = Btn_Width
  KeyCoord(Nmbr,3) = FontH + space
  KeyCoord(Nmbr,4) = RGB(Cyan)
  KeyCaption(Nmbr) = "CHANGE"
  'Go to Sub DrawButton, then come back and finish rest of line.
  DrawButton Nmbr, 0
End Sub '(DrawOption)
  '*****************************************************************************
  ' Draw a button
Sub DrawButton Nmbr As Integer, Pressed As Integer
  If Pressed Then
    'Draw in reverse video if it is being touched
    RBox KeyCoord(Nmbr,0), KeyCoord(Nmbr,1), KeyCoord(Nmbr,2), KeyCoord(Nmbr,3), , KeyCoord(Nmbr,4), KeyCoord(Nmbr,4)
    Text KeyCoord(Nmbr,0) + KeyCoord(Nmbr,2)/2, KeyCoord(Nmbr,1) + KeyCoord(Nmbr,3)/2, KeyCaption(Nmbr), CM, 2, 1, 0, KeyCoord(Nmbr,4)
  Else
    'Otherwise draw a normal button
    RBox KeyCoord(Nmbr,0), KeyCoord(Nmbr,1), KeyCoord(Nmbr,2), KeyCoord(Nmbr,3), , KeyCoord(Nmbr,4), 0
    Text KeyCoord(Nmbr,0) + KeyCoord(Nmbr,2)/2, KeyCoord(Nmbr,1) + KeyCoord(Nmbr,3)/2, KeyCaption(Nmbr), CM, 2, 1, KeyCoord(Nmbr,4), 0
  EndIf
End Sub '(DrawButton)
  '*****************************************************************************
  'Check if a button has been touched and animate the button's image.
  'Returns the button number
  'This next part is a FUNCTION.
Function CheckButtonPress(StartN As Integer, EndN As Integer) As Integer
  Local Integer KeyDwn, Xt, Var1, Nmbr
  KeyDwn = 0
  'Keep looping while waiting for a press and release
  Do
    If Touch(x) <> -1 And Not KeyDwn Then
      ' We have a touch
      Xt = Touch(x)
      Var1 = Touch(y)
      'Scan the array KeyCoord() to see if the touch was within the boundaries
      'of a button.
      For Nmbr = StartN To EndN
        If Xt > KeyCoord(Nmbr,0) And Xt < KeyCoord(Nmbr,0) + KeyCoord(Nmbr,2) And Var1 > KeyCoord(Nmbr,1) And Var1 < KeyCoord(Nmbr,1) + KeyCoord(Nmbr,3) Then
          'We have a button press
          'Draw the button as pressed
          ' Restart program after 10 minutes if no further key presses.
          Watchdog 600000
          'Go to Sub DrawButton, then come back and finish rest of line.
          DrawButton Nmbr, 1
          KeyDwn = 1
          Exit For
        EndIf
      Next Nmbr
    EndIf
    'If a button is currently down check if it has been released
    If Touch(x) = -1 And KeyDwn Then
      'Yes, the button has been released.
      'Draw the button as normal (ie, not pressed).
      'Go to Sub DrawButton, then come back and finish rest of line.
      DrawButton Nmbr, 0
      CheckButtonPress = Nmbr
      'Return with the button's number
      Exit Function
    EndIf
  Loop
End Function '(CheckButtonPress)
  '*****************************************************************************
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' The next two subroutines are responsible for drawing the keypad,
  ' animating the key presses and returning the entered value as a float.
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Get a number.
  ' When the user touches ENT (enter) the value is saved into the variable var
  ' which is parsed as reference as the second argument
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub GetFloat Caption As String, var As Float
  Const Bw = MM.HRes\4, Bh = MM.VRes\5 'Bw = Button Width. Bh = Button Height
  'These are the captions on each key
  Local String Cap(15) = ("7","8","9","","4","5","6","","1","2","3","Can",".","0","Del","ENT")
  Local Integer Key, KeyDwn
  Local Integer X, Y, Xt, Var2, Btn
  Local String S
  
  Cls 0
  'Draw the title
  Text 0, 8, Caption + ": ", , 2, 1, RGB(Yellow), 0
  'Draw the entire keypad (99 means draw them all)
  DrawKeypad 99
  Do
    If Touch(X) <> -1 And Not KeyDwn Then
      'If the panel is touched
      KeyDwn = 1
      Xt = Touch(X)
      Var2 = Touch(Y)
      Btn = 1
      For Y = Bh To MM.VRes - Bh Step Bh
        For X = 0 To MM.HRes - bw Step Bw
          If Cap(Btn-1) <> "" And Xt > X And Xt < X+Bw And Var2 > Y And Var2 < Y+Bh Then
            X = 1000 : Y = 1000 'Exit both loops
          Else
            Btn = Btn + 1
          EndIf
        Next X
      Next Y
      'Continue looping if the touch was not on a key
      If Btn > 16 Then Continue Do
      'Special handling for the +, - and . keys
      If (Btn = 4 Or Btn = 8) And s <> "" Then Continue Do
      If Btn = 13 And Instr(S, ".") > 0 Then Continue Do
      'Draw the key as pressed
      DrawKeypad Btn
      'Special processing for Can (Cancel), Del (Delete) and Ent (Enter)
      If Btn = 12 Or Btn = 16 Then Continue Do
      If Btn = 15 Then
        If S <> "" Then S = Left$(S, Len(S) - 1)
      Else
        S = S + Cap(Btn - 1) 'Add the key to our entered string
      EndIf
      Text Len(Caption + ": ") * 16, 8, S + " ", , 2, 1, RGB(Yellow), 0
    EndIf
    
    'If a key is currently down, check if it has been released
    If Touch(X) = -1 And KeyDwn Then
      'Yes, the key has been released
      'Draw the key as normal (ie, not pressed)
      KeyDwn = 0
      DrawKeypad -Btn
      'If ENT return the value
      If Btn = 16 And S <> "" Then var = Val(S)
      'If Can just return
      If Btn = 12 Or Btn = 16 Then Exit Sub
    EndIf
  Loop
End Sub '(GetFloat)
  '*****************************************************************************
  ' This draws the keypad.
  ' If the argument is 99 all keys will be drawn.
  ' If it is negative the particular key will be drawn as normal.
  ' If it is positive the key will be drawn as depressed.
Sub DrawKeypad BtnDwn As Integer
  Const Bw = MM.HRes\4, Bh = MM.VRes\5
  Local String Cap(15) = ("7","8","9","","4","5","6","","1","2","3","Can",".","0","Del","ENT")
  Local Integer X, Y, Btn
  Btn = 1
  For Y = Bh To MM.VRes - Bh Step Bh
    For X = 0 To MM.HRes - Bw Step Bw
      If Cap(Btn - 1) <> "" Then
        If Btn = BtnDwn Then
          'Draw the key as touched (ie, reverse video)
          RBox X + 5, Y + 5, Bw - 5, Bh - 5, , RGB(Cyan), RGB(Cyan)
          Text X + Bw/2 + 4, Y + Bh/2 + 6, Cap(Btn - 1), CM, 2, 1, 0, RGB(Cyan)
        ElseIf -Btn = BtnDwn Or BtnDwn = 99 Then
          
          'Draw the key as normal
          RBox X + 5, Y + 5, Bw - 5, Bh - 5, , RGB(Cyan), 0
          Text X + Bw/2, Y + Bh/2 + 2, Cap(Btn - 1), CM, 2, 1, RGB(Cyan), 0
        EndIf
      EndIf
      Btn = Btn + 1
    Next X
  Next Y
End Sub '(DrawKeypad)
  '*****************************************************************************
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' This handy routine draws a message box with an OK button,
  ' then waits for the button to be touched
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub MessageBox S1 As String, S2 As String
  Local Integer W
  If Len(S1) > Len(S2) Then W = Len(S1) Else W = Len(S2)
  W = W * 8     ' Get the width of the text (used for the box width)
  
  'Draw the box and the message in it
  RBox MM.HRes/2 - W - 20, 60, W * 2 + 40, 130, , RGB(Yellow), 0
  Text MM.HRes/2, 70, S1, CT, 2, 1, RGB(White)
  Text MM.HRes/2, 100, S2, CT, 2, 1, RGB(White)
  
  'Draw the OK button
  RBox 110, 140, 100, 40, , RGB(Cyan)
  Text MM.HRes/2, 160, "OK", CM, 2, 1, RGB(Cyan)
  
  'Wait for the button to be touched
  Do While Not (Touch(X) > 110 And Touch(X) < 210 And Touch(Y) > 140 And Touch(Y) < 180) : Loop
  
  'Draw the OK button as depressed
  RBox 110, 140, 100, 40, , RGB(Cyan), RGB(Cyan)
  Text MM.HRes/2, 160, "OK", CM, 2, 1, 0, RGB(Cyan)
  
  'Wait for the touch to be removed
  Do While Touch(X) <> -1 : Loop
End Sub '(MessageBox)
  '*****************************************************************************
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Embedded Fonts
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Font: Hom_16x24_LE
  ' Includes all ASCII characters
DefineFont #2
  5F201810 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 80010000 80018001
  80018001 80018001 00018001 00010001 00000000 80010000 00008001 00000000
  00000000 00000000 700E0000 700E700E 2004700E 20042004 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 20010000 20012001
  20012001 F80F2001 40024002 F01F4002 40024002 40024002 40024002 00000000
  00000000 00000000 80008000 E8018000 08041802 00040004 E0010002 08001000
  08080800 E00B100C 80008000 80008000 00000000 00000000 00070000 40108008
  40104010 1C078008 0007E000 88007038 04010401 88000401 00007000 00000000
  00000000 00000000 00000000 00000000 C004A003 00040004 00060002 20113009
  4010C010 A0086010 00001807 00000000 00000000 00000000 70000000 E0007000
  8001C000 00000001 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 10000000 20002000 40004000 80004000 80008000 80008000
  80008000 40004000 20004000 10002000 00000000 00000000 00080000 00040004
  00020002 00010002 00010001 00010001 00010001 00020002 00040002 00080004
  00000000 00000000 80000000 80008000 F007980C 6003C001 180C3006 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  80008000 80008000 FC1F8000 80008000 80008000 00008000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 00038003 00040006 00000000 00000000 00000000 00000000
  00000000 00000000 FC1F0000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 0000C001 00000000 00000000 00000000 08000000 10000800
  20001000 40002000 80004000 00018000 00020001 00040002 00080004 00000008
  00000000 00000000 00000000 3006C001 08081004 08080808 08080808 08080808
  08080808 30061004 0000C001 00000000 00000000 00000000 00000000 800E8001
  80008000 80008000 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 00000000 200CC003 10101010 10001000 40002000 00018000
  00040002 08100008 0000F81F 00000000 00000000 00000000 00000000 3008C007
  10001000 20001000 3000C003 08000800 08000800 300C0810 0000C003 00000000
  00000000 00000000 00000000 A0006000 20012001 20042002 20082004 20102008
  2000F81F 20002000 0000F801 00000000 00000000 00000000 00000000 0008F00F
  00080008 C00B0008 1000300C 08000800 08000800 30181000 0000C007 00000000
  00000000 00000000 00000000 0003F000 00040006 E0090008 080C100A 08080808
  08080808 10060804 0000E001 00000000 00000000 00000000 00000000 1010F01F
  20002010 40002000 40004000 80004000 80008000 00010001 00000001 00000000
  00000000 00000000 00000000 2004C003 10081008 10081008 E0072004 08101008
  08100810 300C1008 0000C003 00000000 00000000 00000000 00000000 3006C001
  0808180C 08080808 28061804 0800C801 10000800 60001000 0000800F 00000000
  00000000 00000000 00000000 00000000 00000000 C001C001 0000C001 00000000
  00000000 C001C001 0000C001 00000000 00000000 00000000 00000000 00000000
  00000000 C001C001 0000C001 00000000 00000000 C001C001 00038003 00040006
  00000000 00000000 00000000 00000000 60001800 00068001 00300018 00060018
  60008001 00001800 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 0000FC3F FC3F0000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00060018 60008001 0C001800 60001800
  00068001 00000018 00000000 00000000 00000000 00000000 00000000 C0070000
  10082008 10001000 20001000 0001C000 00000001 80010000 00008001 00000000
  00000000 00000000 C0030000 1008200C 10101010 90107010 10111011 10111011
  78109010 00100010 300C0008 0000E003 00000000 00000000 00000000 C00F0000
  20024001 20022002 10041004 F80F1004 08080808 04100410 00001E3C 00000000
  00000000 00000000 00000000 F03F0000 04080808 04080408 F00F0808 04080808
  04080408 08080408 0000F03F 00000000 00000000 00000000 00000000 E4010000
  0C0C1406 00100408 00100010 00100010 04080010 18060C0C 0000E001 00000000
  00000000 00000000 00000000 E03F0000 08101810 04100410 04100410 04100410
  04100410 18100810 0000E03F 00000000 00000000 00000000 00000000 F83F0000
  08080808 80080808 800F8008 80088008 04080408 04080408 0000FC3F 00000000
  00000000 00000000 00000000 FC1F0000 04040404 40040404 C0074004 40044004
  00040004 00040004 0000C01F 00000000 00000000 00000000 00000000 C8030000
  1818280C 00200810 00200020 FC200020 08100820 100C0818 0000E003 00000000
  00000000 00000000 00000000 3E3E0000 08080808 08080808 F80F0808 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 00000000 F80F0000
  80008000 80008000 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 00000000 FE030000 10001000 10001000 10001000 10101000
  10101010 60082010 00008007 00000000 00000000 00000000 00000000 3C3E0000
  20081008 80084008 000B0009 4008800C 10082008 08081008 00001E3E 00000000
  00000000 00000000 00000000 803F0000 00040004 00040004 00040004 00040004
  04040404 04040404 0000FC3F 00000000 00000000 00000000 00000000 0E380000
  0C180C18 14141414 24122412 C4114411 04100410 04100410 00001E3C 00000000
  00000000 00000000 00000000 7E780000 08140818 08120812 08110811 88108810
  48104810 18102810 0000187E 00000000 00000000 00000000 00000000 E0030000
  0C18180C 02200410 02200220 02200220 04100220 180C0C18 0000E003 00000000
  00000000 00000000 00000000 F01F0000 04040804 04040404 08040404 0004F007
  00040004 00040004 0000C01F 00000000 00000000 00000000 00000000 E0030000
  0C18180C 02200410 02200220 02200220 04100220 180C0C18 8C01E003 0000F006
  00000000 00000000 00000000 E03F0000 08081008 08080808 10080808 4008E00F
  10082008 08081008 00000E3E 00000000 00000000 00000000 00000000 C8030000
  1810280C 00100810 C003000C 08003000 08100800 10140818 0000E013 00000000
  00000000 00000000 00000000 FC1F0000 84108410 84108410 80008000 80008000
  80008000 80008000 0000F007 00000000 00000000 00000000 00000000 7C3E0000
  08100810 08100810 08100810 08100810 08100810 10080810 0000E007 00000000
  00000000 00000000 00000000 3E3E0000 04100410 08080808 10041004 20021004
  20022002 C0014001 00008000 00000000 00000000 00000000 00000000 3E3E0000
  04100410 84108410 44114411 280A4809 280A280A 180C180C 0000180C 00000000
  00000000 00000000 00000000 3E3E0000 10040808 20021004 80004001 20024001
  10042002 08080808 00003E3E 00000000 00000000 00000000 00000000 1E3C0000
  10040808 20021004 40012002 80008000 80008000 80008000 0000F007 00000000
  00000000 00000000 00000000 F81F0000 10100810 40102010 80004000 00020001
  08040802 08100808 0000F81F 00000000 00000000 00000000 E0000000 80008000
  80008000 80008000 80008000 80008000 80008000 80008000 80008000 E0008000
  00000000 00000000 00080000 00040008 00020004 00010002 80000001 40008000
  20004000 10002000 08001000 00000800 00000000 00000000 80030000 80008000
  80008000 80008000 80008000 80008000 80008000 80008000 80008000 80038000
  00000000 00000000 80000000 2002C001 08081004 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  FF7F0000 00000000 80030000 C0018003 6000C000 00002000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 2008C007 10001000 3008D007 10101010 30081010 0000DC07 00000000
  00000000 00000000 00000000 00080038 00080008 0C0AF009 0208040C 02080208
  02080208 0C0A040C 0000F039 00000000 00000000 00000000 00000000 00000000
  00000000 180CE803 08100808 00100010 00100010 180C0C08 0000E003 00000000
  00000000 00000000 00000000 08003800 08000800 2818C807 08201810 08200820
  08200820 28181810 0000CE07 00000000 00000000 00000000 00000000 00000000
  00000000 180CE003 04100808 FC1F0410 00100010 0C0C0008 0000F003 00000000
  00000000 00000000 00000000 8401F800 00010001 0001F80F 00010001 00010001
  00010001 00010001 0000F80F 00000000 00000000 00000000 00000000 00000000
  00000000 2818CE07 08201810 08200820 08200820 28181810 0800C807 10000800
  C00F3000 00000000 00000000 00080038 00080008 100AE009 0808080C 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 80000000 80008000
  00000000 80008007 80008000 80008000 80008000 80008000 0000F80F 00000000
  00000000 00000000 20000000 20002000 00000000 1000F00F 10001000 10001000
  10001000 10001000 10001000 20001000 800F6000 00000000 00000000 0004001C
  00040004 20047804 80044004 00070005 40048004 10042004 00003C1C 00000000
  00000000 00000000 00000000 8000800F 80008000 80008000 80008000 80008000
  80008000 80008000 0000FC1F 00000000 00000000 00000000 00000000 00000000
  00000000 C4183877 84108410 84108410 84108410 84108410 0000C67C 00000000
  00000000 00000000 00000000 00000000 00000000 100AE039 0808080C 08080808
  08080808 08080808 00003E3E 00000000 00000000 00000000 00000000 00000000
  00000000 180CE003 04100808 04100410 04100410 180C0808 0000E003 00000000
  00000000 00000000 00000000 00000000 00000000 0C0AF039 0208040C 02080208
  02080208 0C0A040C 0008F009 00080008 003F0008 00000000 00000000 00000000
  00000000 2818CE07 08201810 08200820 08200820 28181810 0800C807 08000800
  7E000800 00000000 00000000 00000000 00000000 C402380E 00020003 00020002
  00020002 00020002 0000F01F 00000000 00000000 00000000 00000000 00000000
  00000000 1804E803 00040804 70008003 08000800 100C0808 0000E00B 00000000
  00000000 00000000 00000000 00040004 00040004 0004F01F 00040004 00040004
  00040004 18020004 0000E001 00000000 00000000 00000000 00000000 00000000
  00000000 08083838 08080808 08080808 08080808 28041808 0000CC03 00000000
  00000000 00000000 00000000 00000000 00000000 08083E3E 10040808 10041004
  20022002 C0014001 00008000 00000000 00000000 00000000 00000000 00000000
  00000000 04101E3C 84100410 48098808 48094809 30065005 00003006 00000000
  00000000 00000000 00000000 00000000 00000000 08083C1E 20021004 80004001
  20024001 08081004 00003C1E 00000000 00000000 00000000 00000000 00000000
  00000000 08103C3C 10080810 20081008 40042004 80024002 00018001 00020001
  803F0002 00000000 00000000 00000000 00000000 0808F80F 20001008 80004000
  00020001 08080804 0000F80F 00000000 00000000 00000000 60000000 80008000
  80008000 80008000 80008000 80000003 80008000 80008000 80008000 60008000
  00000000 00000000 00000000 80000000 80008000 80008000 80008000 80008000
  80008000 80008000 80008000 80008000 00000000 00000000 00030000 80008000
  80008000 80008000 80008000 80006000 80008000 80008000 80008000 00038000
  00000000 00000000 00000000 00000000 00000000 00000000 98190C0F 0000F030
  00000000 00000000 00000000 00000000 00000000
End DefineFont
  '*****************************************************************************
  ' ArialNumFontPlus.bas
  ' Font type    : Special (SubSet)
  ' Font size    : 32x50 pixels
  ' Memory usage : 2204 bytes
DefineFont #3
  0B303220 00000000 00000000 00F00F00 00F81F00 00FE7F00 00FFFF00 00FFFF01
  801FF803 C00FF003 C007E007 E003C007 E003C00F F001800F F001800F F001801F
  F800001F F800001F F800001F F800001F FC00003F 7C00003E 7C00003E 7C00003E
  7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003F
  F800001F F800001F F800001F F800001F F001800F F001800F F001800F E003C007
  E003C007 C007E003 C00FF003 801FF801 00FFFF00 00FEFF00 00FC7F00 00F81F00
  00E00700 00000000 00000000 00000000 00000000 00000000 00F00000 00F00100
  00F00300 00F00700 00F00F00 00F01F00 00F03F00 00F07F00 00F0FF01 00F0FD03
  00F0F10F 00F0E10F 00F0810F 00F0010F 00F0010C 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100 00F00100
  00F00100 00F00100 00F00100 00000000 00000000 00000000 00000000 00F00F00
  00FE7F00 00FFFF01 C0FFFF03 E0FFFF03 F00FE007 F003C00F F001800F F800001F
  F800001F F800003E 7C00003E 7C00003E 7C000000 7C000000 7C000000 78000000
  F8000000 F8010000 F0030000 F0070000 E00F0000 C01F0000 803F0000 007F0000
  00FE0000 00FC0100 00F80300 00F00700 00E00F00 00C01F00 00803F00 00007F00
  0000FE00 0000FC01 0000F803 0000F007 0000E007 0000C00F 0000800F 0000801F
  FCFFFF3F FCFFFF3F FCFFFF7F FCFFFF7F FCFFFF7F 00000000 00000000 00000000
  00000000 00F00F00 00FC3F00 00FEFF00 00FFFF01 80FFFF03 C01FE003 C00FC007
  E0078007 E003800F E003000F F003000F F001000F F0030000 E0030000 E0030000
  E0070000 C00F0000 C01F0000 803F0000 00FF0700 00FF0700 00FF0700 80FF0700
  C01F0000 E00F0000 E0030000 F0010000 F0000000 F8000000 F8000000 FC000000
  FC000000 FC000000 FC00001F FC00001F F800001F F801001F F801800F F003800F
  F007C00F E00FE007 C03FFC03 80FFFF01 00FFFF00 00FC7F00 00F00F00 00000000
  00000000 00000000 00000000 000F0000 001F0000 001F0000 003F0000 003F0000
  007F0000 007F0000 00FF0000 00FF0100 00FF0100 00FF0300 00DF0700 00DF0700
  009F0F00 009F0F00 001F1F00 001F3E00 001F7E00 001F7C00 001FF800 001FF800
  001FF001 001FE003 001FE003 001FC007 001FC007 001F800F 001F801F 001F001F
  001F003E FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F 001F0000 001F0000
  001F0000 001F0000 001F0000 001F0000 001F0000 001F0000 001F0000 001F0000
  001F0000 00000000 00000000 00000000 00000000 F0FFFF01 F0FFFF01 F0FFFF01
  F0FFFF01 F0FFFF01 0000E003 0000C003 0000C003 0000C003 0000C007 0000C007
  0000C007 0000C007 00008007 0000800F 00F0800F 00FE8F0F 80FFBF0F C0FFFF0F
  E0FFFF0F F007FF1F F003E01F F801C01F F800001F F8000000 FC000000 7C000000
  7C000000 7C000000 7C000000 7C000000 7C000000 7C000000 F800003F F800003F
  F800003F F000001F F001001F E003801F E007C00F C01FE007 80FFFF03 00FFFF03
  00FEFF01 00F87F00 00E00F00 00000000 00000000 00000000 00000000 00F00F00
  00FE3F00 00FFFF00 80FFFF01 C0FFFF03 E007E007 F003C007 F001C00F F800800F
  F800801F F800801F 0000001F 0000001F 0000003F 0000003F 0000003F 00F0033F
  00FC1F3F 00FE7F3F 80FFFF3F C0FFFF3F E00FF83F F003E03F F003E03F F801C03F
  F800803F F800803F 7C00003F 7C00003F 7C00003F 7C00003F 7C00003F 7C00003F
  7C00001F 7800801F F800801F F800801F F800800F F001C00F F003F007 E00FF803
  C0FFFF01 80FFFF00 00FF7F00 00FC1F00 00F00300 00000000 00000000 00000000
  00000000 FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FCFFFF3F FC000000 FC000000
  F8010000 F0010000 E0030000 E0030000 C0070000 800F0000 001F0000 003E0000
  007C0000 00FC0000 00F80000 00F00000 00F00100 00F00100 00E00300 00E00300
  00E00300 00C00700 00C00700 00800F00 00800F00 00800F00 00001F00 00001F00
  00001F00 00001F00 00003E00 00003E00 00003E00 00003E00 00003E00 00007C00
  00007C00 00007C00 00007C00 00007C00 0000F800 0000F800 0000F800 00000000
  00000000 00000000 00000000 00F00F00 00FE7F00 80FFFF00 80FFFF01 C01FF803
  E007E007 E003C007 F003C00F F001800F F001800F F001800F F001800F F001800F
  F001800F E003C007 E003C007 C007E003 8007F001 003FFC00 00FF7F00 00FC3F00
  00FE7F00 00FFFF00 C0FFFF03 E00FF007 F003C00F F001800F F801801F F800001F
  F800001F 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E 7C00003E F800001F
  F800001F F001800F F003800F E007C007 C00FF003 80FFFF01 00FFFF00 00FC3F00
  00F00F00 00000000 00000000 00000000 00000000 00F00F00 00FC3F00 00FFFF00
  80FFFF01 C0FFFF03 E01FF803 E007E007 F007E007 F003C00F F803C00F F801801F
  F801801F FC00001F FC00001F FC00001F FC00001F FC00001F FC00001F FC01801F
  FC01801F FC03C00F FC03C00F FC07E007 FC07E007 FC1FF803 FCFFFF01 FCFFFF00
  FCFEFF00 FCF87F00 FCE01F00 FC000000 FC000000 FC000000 FC000000 F8010000
  F801003F F001003F F003001F E007801F E00FC00F C03FE00F 80FFFF07 00FFFF03
  00FEFF01 00F8FF00 00E03F00 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00E00000 00F00100 00F80300 00F80300 00F80300 00F00100 00E00000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00E00000 00F00100
  00F80300 00F80300 00F80300 00F00100 00E00000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000
End DefineFont
  '*****************************************************************************